/*
 * Decompiled with CFR 0.152.
 */
package Calc4M;

import Calc4M.Settings;
import ral.Real;

public class StackElement {
    public static final int EditingNumber = 1;
    public static final int FinishedNumber = 2;
    public static final int LeftParanthesis = 3;
    public static final int CalcAddition = 4;
    public static final int CalcSubtraction = 5;
    public static final int CalcMultiplication = 6;
    public static final int CalcDivision = 7;
    public static final int CalcRaised = 8;
    private static Real.NumberFormat secondFormat = new Real.NumberFormat();
    private Real value;
    private String valueString = null;
    private int calcType;

    public StackElement(int calcType) {
        this.calcType = calcType;
    }

    public StackElement(Real value) {
        this.calcType = 2;
        this.value = value;
    }

    public StackElement(String valueString) {
        this.calcType = 1;
        this.valueString = valueString;
    }

    public int getCalcType() {
        return this.calcType;
    }

    public Real getValue() {
        switch (this.calcType) {
            case 2: {
                return this.value;
            }
            case 1: {
                return new Real(this.valueString, Settings.getCalcBase());
            }
        }
        return null;
    }

    public int getPriority() {
        switch (this.calcType) {
            case 4: 
            case 5: {
                return 1;
            }
            case 6: 
            case 7: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 3: {
                return -1;
            }
        }
        return 0;
    }

    public String toString(boolean displayAsArc) {
        return this.toString(null, displayAsArc);
    }

    public String toString(Real.NumberFormat format, boolean displayAsArc) {
        switch (this.calcType) {
            case 1: {
                return this.valueString;
            }
            case 2: {
                if (displayAsArc) {
                    StackElement.secondFormat.fse = 0;
                    int degrees = this.value.toInteger();
                    String degreeString = this.trimNumberString(new Real(degrees).toString(format));
                    Real seconds = new Real(this.value);
                    seconds.abs();
                    seconds.sub(degrees);
                    seconds.mul(60);
                    int minutes = seconds.toInteger();
                    String minuteString = this.trimNumberString(new Real(minutes).toString(format));
                    seconds.sub(minutes);
                    seconds.mul(60);
                    int tmpMaxwidth = format.maxwidth;
                    format.maxwidth = Math.max(tmpMaxwidth - 8, 8);
                    String secondString = this.trimNumberString(seconds.toString(format));
                    format.maxwidth = tmpMaxwidth;
                    String tmpString = degreeString + "\u00ba " + (minuteString.length() < 2 ? "0" : "") + minuteString + "' " + (secondString.length() < 2 ? "0" : "") + secondString + "\"";
                    return tmpString;
                }
                return format == null ? this.value.toString() : this.trimNumberString(this.value.toString(format));
            }
            case 3: {
                return "(";
            }
            case 4: {
                return "+";
            }
            case 5: {
                return "-";
            }
            case 6: {
                return "*";
            }
            case 7: {
                return "/";
            }
            case 8: {
                return "^";
            }
        }
        return "";
    }

    public void addToValueString(char ch) {
        if (this.valueString.indexOf(ch) > 0 && (ch == 'e' || ch == '.') || ch == '.' && this.valueString.indexOf("e") > 0) {
            return;
        }
        if (ch == '-') {
            this.valueString = this.valueString.indexOf("e") == this.valueString.length() - 1 ? this.valueString + ch : (this.valueString.indexOf("-") == 0 ? this.valueString.substring(1) : "-" + this.valueString);
            return;
        }
        this.valueString = this.valueString + ch;
    }

    public void addToValueString(int i) {
        this.valueString = this.valueString + i;
    }

    public void setValueString(String valueString) {
        this.valueString = valueString;
    }

    public String getValueString() {
        return this.valueString;
    }

    public boolean isValue() {
        return this.calcType == 1 && !this.valueString.equals("-") || this.calcType == 2;
    }

    public boolean isEditingNumberEmpty() {
        return this.calcType == 1 && this.valueString.length() == 0;
    }

    private String trimNumberString(String numberString) {
        int i;
        for (i = 0; i < numberString.length() && numberString.charAt(i) == '0'; ++i) {
        }
        if (i > 0) {
            if (numberString.length() <= i || numberString.charAt(i) == '.') {
                return numberString.substring(i - 1);
            }
            return numberString.substring(i);
        }
        return numberString;
    }
}

