/*
 * Decompiled with CFR 0.152.
 */
package Calc4M.midp1;

import Calc4M.midp1.Calc4M;
import Calc4M.midp1.CalcButton;
import Calc4M.midp1.CalcStack;
import Calc4M.midp1.CalcTextBox;
import Calc4M.midp1.Constants;
import Calc4M.midp1.Header;
import Calc4M.midp1.Key;
import Calc4M.midp1.Menu;
import Calc4M.midp1.MenuList;
import Calc4M.midp1.Settings;
import Calc4M.midp1.StackElement;
import Calc4M.midp1.UndoRedoStack;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import ral.Real;

public class DashBoard
extends Canvas {
    public static final int CALC_MODE_Arithmetic = 1;
    public static final int CALC_MODE_TrigLog = 2;
    public static final int CALC_MODE_Mem = 3;
    public static final int CALC_MODE_Convert = 4;
    public static final int CALC_MODE_Convert2 = 5;
    public static final int CALC_MODE_HexBin = 6;
    public static final int COLOR_BACKGROUND = 0;
    private static final int REPEAT_WAIT = 600;
    private static Display display;
    private static Settings settings;
    private int width;
    private int height;
    private int buttonWidth;
    private int buttonHeight;
    private CalcButton b0;
    private CalcButton b1;
    private CalcButton b2;
    private CalcButton b3;
    private CalcButton b4;
    private CalcButton b5;
    private CalcButton b6;
    private CalcButton b7;
    private CalcButton b8;
    private CalcButton b9;
    private CalcButton bStar;
    private CalcButton bPound;
    private CalcButton bC;
    private CalcButton bBack;
    private CalcButton bUp;
    private CalcButton bDown;
    private CalcButton bLeft;
    private CalcButton bRight;
    private CalcButton bFire;
    private CalcButton bSoftLeft;
    private CalcButton bSoftRight;
    private CalcButton bSend;
    private int currentMode;
    private boolean buttonRepeat;
    private CalcStack calcStack;
    private UndoRedoStack undoStack;
    private UndoRedoStack redoStack;
    private static Calc4M app;
    private Header header = null;
    private CalcTextBox calcTextBox = null;
    private MenuList menuList = null;
    private static Timer timer;
    private CalcButton pressedButton = null;
    private int pressedX = -1;
    private int pressedY = -1;
    private byte startDRG = Settings.getDRG();
    private int startBase = Settings.getCalcBase();
    private boolean isReUndoing;

    public DashBoard(Calc4M app, Display display, Settings settings) {
        DashBoard.app = app;
        DashBoard.display = display;
        DashBoard.settings = settings;
        this.calcStack = new CalcStack();
        this.undoStack = new UndoRedoStack();
        this.redoStack = new UndoRedoStack();
        this.header = new Header();
        this.calcTextBox = new CalcTextBox();
        this.menuList = new MenuList();
        switch (Key.getVendor()) {
            case 2: {
                this.menuList.setTexts("=", "Menu");
                break;
            }
            case 3: {
                this.menuList.setTexts("Menu", "Clear");
                break;
            }
            default: {
                this.menuList.setTexts("Clear", "Menu");
            }
        }
        this.b1 = new CalcButton(1);
        this.b2 = new CalcButton(2);
        this.b3 = new CalcButton(3);
        this.b4 = new CalcButton(4);
        this.b5 = new CalcButton(5);
        this.b6 = new CalcButton(6);
        this.b7 = new CalcButton(7);
        this.b8 = new CalcButton(8);
        this.b9 = new CalcButton(9);
        this.bStar = new CalcButton(10);
        this.b0 = new CalcButton(0);
        this.bPound = new CalcButton(11);
        this.bC = new CalcButton(12);
        this.bC.setFunctionalities(69, 70);
        this.bBack = new CalcButton(13);
        this.bBack.setFunctionalities(71, 0);
        this.bUp = new CalcButton(15);
        this.bDown = new CalcButton(17);
        this.bLeft = new CalcButton(14);
        this.bLeft.setFunctionalities(71, 163);
        this.bRight = new CalcButton(16);
        this.bRight.setFunctionalities(72, 164);
        this.bFire = new CalcButton(18);
        this.bFire.setFunctionalities(12, 140);
        this.bSoftLeft = new CalcButton(19);
        this.bSoftRight = new CalcButton(20);
        this.bSend = new CalcButton(21);
        this.bSend.setFunctionalities(12, 0);
        this.setFullScreenMode(Settings.getFullScreen());
        this.sizeChanged(0, 0);
        this.setMode(1);
    }

    public void setNumberFormat(byte numberFormat) {
        this.calcTextBox.setNumberFormat(numberFormat);
        this.header.updateText(this.currentMode);
        this.calcStack.makeAllFinished();
        this.updateCalcTextBox();
        this.repaint();
    }

    public void updateCalcFont() {
        this.repaint();
    }

    private void clear() {
        if (this.calcStack.isEmpty()) {
            this.setMode(1);
        } else {
            StackElement top = this.calcStack.peek();
            if (top.getCalcType() == 1) {
                top.setValueString(top.getValueString().substring(0, top.getValueString().length() - 1));
                if (top.isEditingNumberEmpty()) {
                    this.calcStack.pop();
                }
            } else {
                this.calcStack.pop();
            }
        }
        this.updateCalcTextBox();
        this.repaint();
    }

    private void allClear() {
        this.calcStack.clear();
        this.undoStack.clear();
        this.setMode(1);
        this.startDRG = Settings.getDRG();
        this.startBase = Settings.getCalcBase();
    }

    public void undo(boolean undoAll) {
        if (this.undoStack.isEmpty()) {
            this.setMode(1);
        } else {
            this.redoStack.push(this.undoStack.pop());
            this.calcStack.clear();
            Settings.setDRG(this.startDRG);
            Settings.setCalcBase(this.startBase);
            this.header.updateText(this.currentMode);
            if (undoAll) {
                while (this.undoStack.size() > 0) {
                    this.redoStack.push(this.undoStack.pop());
                }
            } else {
                int sz = this.undoStack.size();
                this.isReUndoing = true;
                for (int i = 0; i < sz; ++i) {
                    this.handleFunction(this.undoStack.peek(i));
                }
                this.isReUndoing = false;
                this.undoStack.setSize(sz);
            }
        }
        this.calcStack.evaluate();
        this.updateCalcTextBox();
    }

    private void redo(boolean redoAll) {
        if (!this.redoStack.isEmpty()) {
            this.isReUndoing = true;
            if (redoAll) {
                while (this.redoStack.size() > 0) {
                    this.handleFunction(this.redoStack.pop());
                }
            } else {
                this.handleFunction(this.redoStack.pop());
            }
            this.isReUndoing = false;
            this.calcStack.evaluate();
        }
        this.updateCalcTextBox();
    }

    public void setFullScreenMode(boolean fullscreen) {
        this.bSoftLeft.setFunctionalities(0, 0);
        this.bSoftRight.setFunctionalities(0, 0);
        if (Key.getVendor() != 3 && Key.getVendor() != 5) {
            this.addCommand(DashBoard.app.commandEquals);
        }
        this.addCommand(DashBoard.app.commandExit);
        this.addCommand(DashBoard.app.commandToArith);
        this.addCommand(DashBoard.app.commandNext);
        this.addCommand(DashBoard.app.commandUndo);
        this.addCommand(DashBoard.app.commandConstants);
        this.addCommand(DashBoard.app.commandSettings);
        this.addCommand(DashBoard.app.commandHelp);
        if (Key.getVendor() != 2) {
            this.addCommand(DashBoard.app.commandClear);
        }
    }

    public int nextMode() {
        switch (this.currentMode) {
            case 1: {
                this.setMode(2);
                break;
            }
            case 2: {
                this.setMode(6);
                break;
            }
            case 6: {
                this.setMode(3);
                break;
            }
            case 3: {
                this.setMode(4);
                break;
            }
            case 4: {
                this.setMode(5);
                break;
            }
            case 5: {
                this.setMode(1);
            }
        }
        return this.currentMode;
    }

    public int previousMode() {
        switch (this.currentMode) {
            case 1: {
                this.setMode(5);
                break;
            }
            case 2: {
                this.setMode(1);
                break;
            }
            case 6: {
                this.setMode(2);
                break;
            }
            case 3: {
                this.setMode(6);
                break;
            }
            case 4: {
                this.setMode(3);
                break;
            }
            case 5: {
                this.setMode(4);
            }
        }
        return this.currentMode;
    }

    public void setMode(int mode) {
        this.currentMode = mode;
        if (mode == 1) {
            if (Settings.getUseAlternativeLayout()) {
                this.b1.setFunctionalities(2, 15);
                this.b2.setFunctionalities(3, 18);
                this.b3.setFunctionalities(4, 21);
                this.b4.setFunctionalities(5, 24);
                this.b5.setFunctionalities(6, 14);
                this.b6.setFunctionalities(7, 13);
                this.b7.setFunctionalities(8, 16);
                this.b8.setFunctionalities(9, 17);
                this.b9.setFunctionalities(10, 19);
                this.bStar.setFunctionalities(11, 22);
                this.b0.setFunctionalities(1, 23);
                this.bPound.setFunctionalities(12, 20);
            } else {
                this.b1.setFunctionalities(2, 13);
                this.b2.setFunctionalities(3, 14);
                this.b3.setFunctionalities(4, 15);
                this.b4.setFunctionalities(5, 16);
                this.b5.setFunctionalities(6, 17);
                this.b6.setFunctionalities(7, 18);
                this.b7.setFunctionalities(8, 19);
                this.b8.setFunctionalities(9, 20);
                this.b9.setFunctionalities(10, 21);
                this.bStar.setFunctionalities(11, 22);
                this.b0.setFunctionalities(1, 23);
                this.bPound.setFunctionalities(12, 24);
            }
            this.bUp.setFunctionalities(145, 140);
            this.bDown.setFunctionalities(141, 140);
        } else if (mode == 2) {
            this.b1.setFunctionalities(25, 26);
            this.b2.setFunctionalities(27, 28);
            this.b3.setFunctionalities(29, 30);
            this.b4.setFunctionalities(31, 32);
            this.b5.setFunctionalities(33, 34);
            this.b6.setFunctionalities(35, 36);
            this.b7.setFunctionalities(38, 37);
            this.b8.setFunctionalities(139, 39);
            this.b9.setFunctionalities(73, 74);
            this.bStar.setFunctionalities(42, 138);
            this.b0.setFunctionalities(40, 41);
            this.bPound.setFunctionalities(43, 44);
            this.bUp.setFunctionalities(140, 140);
            this.bDown.setFunctionalities(143, 140);
        } else if (mode == 3) {
            this.b1.setFunctionalities(45, 0);
            this.b2.setFunctionalities(46, 0);
            this.b3.setFunctionalities(47, 48);
            this.b4.setFunctionalities(49, 0);
            this.b5.setFunctionalities(50, 0);
            this.b6.setFunctionalities(51, 52);
            this.b7.setFunctionalities(53, 0);
            this.b8.setFunctionalities(54, 0);
            this.b9.setFunctionalities(55, 56);
            this.bStar.setFunctionalities(57, 0);
            this.b0.setFunctionalities(58, 0);
            this.bPound.setFunctionalities(59, 60);
            this.bUp.setFunctionalities(143, 140);
            this.bDown.setFunctionalities(144, 140);
        } else if (mode == 4) {
            this.b1.setFunctionalities(94, 95);
            this.b2.setFunctionalities(96, 97);
            this.b3.setFunctionalities(92, 93);
            this.b4.setFunctionalities(98, 99);
            this.b5.setFunctionalities(100, 101);
            this.b6.setFunctionalities(108, 109);
            this.b7.setFunctionalities(110, 111);
            this.b8.setFunctionalities(112, 113);
            this.b9.setFunctionalities(114, 115);
            this.bStar.setFunctionalities(122, 123);
            this.b0.setFunctionalities(124, 125);
            this.bPound.setFunctionalities(126, 127);
            this.bUp.setFunctionalities(142, 140);
            this.bDown.setFunctionalities(145, 140);
        } else if (mode == 5) {
            this.b1.setFunctionalities(80, 81);
            this.b2.setFunctionalities(82, 83);
            this.b3.setFunctionalities(84, 85);
            this.b4.setFunctionalities(86, 87);
            this.b5.setFunctionalities(88, 89);
            this.b6.setFunctionalities(90, 91);
            this.b7.setFunctionalities(106, 107);
            this.b8.setFunctionalities(102, 103);
            this.b9.setFunctionalities(104, 105);
            this.bStar.setFunctionalities(116, 117);
            this.b0.setFunctionalities(118, 119);
            this.bPound.setFunctionalities(120, 121);
            this.bUp.setFunctionalities(144, 140);
            this.bDown.setFunctionalities(140, 140);
        } else if (mode == 6) {
            this.b1.setFunctionalities(2, 128);
            this.b2.setFunctionalities(3, 129);
            this.b3.setFunctionalities(4, 130);
            this.b4.setFunctionalities(5, 131);
            this.b5.setFunctionalities(6, 132);
            this.b6.setFunctionalities(7, 133);
            this.b7.setFunctionalities(8, 134);
            this.b8.setFunctionalities(9, 135);
            this.b9.setFunctionalities(10, 136);
            this.bStar.setFunctionalities(11, 22);
            this.b0.setFunctionalities(1, 23);
            this.bPound.setFunctionalities(12, 137);
            this.bUp.setFunctionalities(141, 140);
            this.bDown.setFunctionalities(142, 140);
        }
        this.header.updateText(this.currentMode);
        this.repaint();
    }

    public void setMode() {
        this.setMode(this.currentMode);
    }

    private void pushReal(Real value) {
        if (!this.calcStack.isEmpty() && this.calcStack.peek().isValue()) {
            this.calcStack.pop();
        }
        this.calcStack.push(value);
        this.updateCalcTextBox();
    }

    private CalcButton keyCode2Button(int keyCode, boolean repeat) {
        CalcButton b = null;
        switch (Key.keyCode2Key(keyCode, this)) {
            case 1: {
                b = this.b0;
                break;
            }
            case 2: {
                b = this.b1;
                break;
            }
            case 3: {
                b = this.b2;
                break;
            }
            case 4: {
                b = this.b3;
                break;
            }
            case 5: {
                b = this.b4;
                break;
            }
            case 6: {
                b = this.b5;
                break;
            }
            case 7: {
                b = this.b6;
                break;
            }
            case 8: {
                b = this.b7;
                break;
            }
            case 9: {
                b = this.b8;
                break;
            }
            case 10: {
                b = this.b9;
                break;
            }
            case 11: {
                b = this.bStar;
                break;
            }
            case 12: {
                b = this.bPound;
                break;
            }
            case 20: {
                b = this.bBack;
                break;
            }
            case 18: {
                b = this.bC;
                break;
            }
            case 15: {
                b = this.bDown;
                break;
            }
            case 17: {
                b = this.bFire;
                break;
            }
            case 16: {
                b = this.bLeft;
                break;
            }
            case 14: {
                b = this.bRight;
                break;
            }
            case 19: {
                b = this.bSend;
                break;
            }
            case 21: {
                b = this.bSoftLeft;
                break;
            }
            case 22: {
                b = this.bSoftRight;
                break;
            }
            case 13: {
                b = this.bUp;
            }
        }
        if (b != null && (repeat && b.getLongFunctionality() == 0 || !repeat && b.getShortFunctionality() == 0)) {
            b = null;
        }
        return b;
    }

    private CalcButton position2Button(int x, int y) {
        CalcButton[] buttons = new CalcButton[]{this.b0, this.b1, this.b2, this.b3, this.b4, this.b5, this.b6, this.b7, this.b8, this.b9, this.bStar, this.bPound, this.bBack, this.bC, this.bDown, this.bFire, this.bLeft, this.bRight, this.bSend, this.bSoftLeft, this.bSoftRight, this.bUp};
        CalcButton b = null;
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].isPosOn(x, y)) continue;
            b = buttons[i];
            break;
        }
        if (b != null && b.getShortFunctionality() == 0) {
            b = null;
        }
        return b;
    }

    private int button2Function(CalcButton currButton, boolean repeat) {
        if (currButton == null) {
            return 0;
        }
        return repeat ? currButton.getLongFunctionality() : currButton.getShortFunctionality();
    }

    public void handleFunction(int function) {
        boolean clearRedo = true;
        boolean displayAsArc = false;
        this.undoStack.push(function);
        switch (function) {
            case 70: {
                this.allClear();
                break;
            }
            case 69: {
                this.clear();
                break;
            }
            case 71: {
                this.undoStack.pop();
                clearRedo = false;
                this.undo(false);
                break;
            }
            case 163: {
                this.undoStack.pop();
                clearRedo = false;
                this.undo(true);
                break;
            }
            case 72: {
                this.undoStack.pop();
                if (this.redoStack.isEmpty()) {
                    this.handleFunction(12);
                    break;
                }
                clearRedo = false;
                this.redo(false);
                break;
            }
            case 164: {
                this.undoStack.pop();
                clearRedo = false;
                this.redo(true);
                break;
            }
            case 1: 
            case 2: {
                this.addEditingNumber((char)(48 + (function - 1)));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (Settings.getCalcBase() <= 2) break;
                this.addEditingNumber((char)(48 + (function - 1)));
                break;
            }
            case 9: 
            case 10: {
                if (Settings.getCalcBase() <= 8) break;
                this.addEditingNumber((char)(48 + (function - 1)));
                break;
            }
            case 11: {
                this.addEditingNumber('.');
                break;
            }
            case 22: {
                if (this.calcStack.isEmpty() || this.calcStack.peek().getCalcType() != 1) break;
                this.calcStack.peek().addToValueString('e');
                break;
            }
            case 38: {
                this.pushReal(new Real(Real.PI));
                break;
            }
            case 42: {
                this.pushReal(new Real(Real.E));
                break;
            }
            case 37: {
                Settings.nextDRG();
                this.header.updateText(this.currentMode);
                break;
            }
            case 139: {
                this.calcStack.makeAllFinished();
                displayAsArc = true;
                break;
            }
            case 138: {
                this.undoStack.pop();
                Settings.nextLocalFSE();
                this.calcTextBox.setNumberFormat(Settings.getLocalNFSE());
                this.header.updateText(this.currentMode);
                this.calcStack.makeAllFinished();
                break;
            }
            case 0: {
                clearRedo = false;
                break;
            }
            case 23: {
                if (this.calcStack.isEmpty()) {
                    this.calcStack.push("-");
                    break;
                }
                StackElement top = this.calcStack.peek();
                if (top.getCalcType() == 1) {
                    this.addEditingNumber('-');
                    break;
                }
                if (top.getCalcType() == 2) {
                    top.getValue().neg();
                    break;
                }
                this.calcStack.push("-");
                break;
            }
            case 73: {
                this.calcStack.switchOperands();
                break;
            }
            case 74: {
                this.calcStack.evaluatePercent();
                break;
            }
            case 140: {
                this.undoStack.pop();
                clearRedo = false;
                this.setMode(1);
                break;
            }
            case 141: {
                this.undoStack.pop();
                clearRedo = false;
                this.setMode(2);
                break;
            }
            case 142: {
                this.undoStack.pop();
                clearRedo = false;
                this.setMode(3);
                break;
            }
            case 144: {
                this.undoStack.pop();
                clearRedo = false;
                this.setMode(4);
                break;
            }
            case 145: {
                this.undoStack.pop();
                clearRedo = false;
                this.setMode(5);
                break;
            }
            case 143: {
                this.undoStack.pop();
                clearRedo = false;
                this.setMode(6);
                break;
            }
            case 12: {
                if (this.undoStack.peek(this.undoStack.size() - 2) == 12) {
                    this.undoStack.pop();
                    break;
                }
                this.calcStack.evaluateEqual();
                break;
            }
            case 20: {
                this.calcStack.evaluateRP();
                break;
            }
            case 75: {
                this.undoStack.pop();
                clearRedo = false;
                Menu.show(app, display, settings, this, Key.getVendor() == 3);
                break;
            }
            case 80: {
                this.calcStack.topMultiply(Constants.cmPerInch);
                break;
            }
            case 81: {
                this.calcStack.topDivide(Constants.cmPerInch);
                break;
            }
            case 82: {
                this.calcStack.topMultiply(Constants.cmPerFoot);
                break;
            }
            case 83: {
                this.calcStack.topDivide(Constants.cmPerFoot);
                break;
            }
            case 84: {
                this.calcStack.topMultiply(Constants.mPerYd);
                break;
            }
            case 85: {
                this.calcStack.topDivide(Constants.mPerYd);
                break;
            }
            case 86: {
                this.calcStack.topMultiply(Constants.mPerMile);
                this.calcStack.topDivide(new Real(1000));
                break;
            }
            case 87: {
                this.calcStack.topDivide(Constants.mPerMile);
                this.calcStack.topMultiply(new Real(1000));
                break;
            }
            case 88: {
                this.calcStack.topMultiply(Constants.kmPerNmile);
                break;
            }
            case 89: {
                this.calcStack.topDivide(Constants.kmPerNmile);
                break;
            }
            case 90: {
                this.calcStack.topMultiply(Constants.hectarPerAcre);
                break;
            }
            case 91: {
                this.calcStack.topDivide(Constants.hectarPerAcre);
                break;
            }
            case 92: {
                this.calcStack.topMultiply(Constants.mPerMile);
                this.calcStack.topDivide(new Real(1000));
                break;
            }
            case 93: {
                this.calcStack.topDivide(Constants.mPerMile);
                this.calcStack.topMultiply(new Real(1000));
                break;
            }
            case 94: {
                this.calcStack.topDivide(new Real("3.6"));
                break;
            }
            case 95: {
                this.calcStack.topMultiply(new Real("3.6"));
                break;
            }
            case 96: {
                this.calcStack.topMultiply(Constants.mPerMile);
                this.calcStack.topDivide(new Real(3600));
                break;
            }
            case 97: {
                this.calcStack.topDivide(Constants.mPerMile);
                this.calcStack.topMultiply(new Real(3600));
                break;
            }
            case 100: {
                this.calcStack.topMultiply(Constants.kmPerNmile);
                break;
            }
            case 101: {
                this.calcStack.topDivide(Constants.kmPerNmile);
                break;
            }
            case 98: {
                this.calcStack.topMultiply(Constants.kmPerNmile);
                this.calcStack.topDivide(new Real("3.6"));
                break;
            }
            case 99: {
                this.calcStack.topDivide(Constants.kmPerNmile);
                this.calcStack.topMultiply(new Real("3.6"));
                break;
            }
            case 102: {
                this.calcStack.topMultiply(Constants.gPerOz);
                break;
            }
            case 103: {
                this.calcStack.topDivide(Constants.gPerOz);
                break;
            }
            case 104: {
                this.calcStack.topMultiply(Constants.kgPerLb);
                break;
            }
            case 105: {
                this.calcStack.topDivide(Constants.kgPerLb);
                break;
            }
            case 106: {
                this.calcStack.topMultiply(Constants.lPerUSGallon);
                break;
            }
            case 107: {
                this.calcStack.topDivide(Constants.lPerUSGallon);
                break;
            }
            case 108: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.mpgToL100km(this.calcStack.pop().getValue()));
                break;
            }
            case 109: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.L100kmToMpg(this.calcStack.pop().getValue()));
                break;
            }
            case 110: {
                this.calcStack.topMultiply(Constants.wPerHp);
                this.calcStack.topDivide(new Real(1000));
                break;
            }
            case 111: {
                this.calcStack.topDivide(Constants.wPerHp);
                this.calcStack.topMultiply(new Real(1000));
                break;
            }
            case 112: {
                this.calcStack.topMultiply(Constants.jPerKcal);
                this.calcStack.topDivide(new Real(1000));
                break;
            }
            case 113: {
                this.calcStack.topDivide(Constants.jPerKcal);
                this.calcStack.topMultiply(new Real(1000));
                break;
            }
            case 114: {
                this.calcStack.topMultiply(Constants.mjPerKwh);
                break;
            }
            case 115: {
                this.calcStack.topDivide(Constants.mjPerKwh);
                break;
            }
            case 116: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.fToC(this.calcStack.pop().getValue()));
                break;
            }
            case 117: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.cToF(this.calcStack.pop().getValue()));
                break;
            }
            case 118: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(this.calcStack.pop().getValue().add(Constants.kAt0C));
                break;
            }
            case 119: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(this.calcStack.pop().getValue().sub(Constants.kAt0C));
                break;
            }
            case 120: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.fToC(this.calcStack.pop().getValue()).add(Constants.kAt0C));
                break;
            }
            case 121: {
                if (!this.calcStack.popTillNumber()) break;
                this.calcStack.push(Constants.cToF(this.calcStack.pop().getValue().sub(Constants.kAt0C)));
                break;
            }
            case 122: {
                this.calcStack.topMultiply(Constants.paPerBar);
                break;
            }
            case 123: {
                this.calcStack.topDivide(Constants.paPerBar);
                break;
            }
            case 124: {
                this.calcStack.topMultiply(Constants.paPerMmhg);
                break;
            }
            case 125: {
                this.calcStack.topDivide(Constants.paPerMmhg);
                break;
            }
            case 127: {
                this.calcStack.topMultiply(Constants.paPerMmhg);
                this.calcStack.topDivide(Constants.paPerBar);
                break;
            }
            case 126: {
                this.calcStack.topMultiply(Constants.paPerBar);
                this.calcStack.topDivide(Constants.paPerMmhg);
                break;
            }
            case 134: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(2);
                this.header.updateText(this.currentMode);
                break;
            }
            case 135: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(8);
                this.header.updateText(this.currentMode);
                break;
            }
            case 136: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(10);
                this.header.updateText(this.currentMode);
                break;
            }
            case 137: {
                this.calcStack.makeAllFinished();
                Settings.setCalcBase(16);
                this.header.updateText(this.currentMode);
                break;
            }
            case 128: {
                if (Settings.getCalcBase() <= 10) break;
                this.addEditingNumber('A');
                break;
            }
            case 129: {
                if (Settings.getCalcBase() <= 11) break;
                this.addEditingNumber('B');
                break;
            }
            case 130: {
                if (Settings.getCalcBase() <= 12) break;
                this.addEditingNumber('C');
                break;
            }
            case 131: {
                if (Settings.getCalcBase() <= 13) break;
                this.addEditingNumber('D');
                break;
            }
            case 132: {
                if (Settings.getCalcBase() <= 14) break;
                this.addEditingNumber('E');
                break;
            }
            case 133: {
                if (Settings.getCalcBase() <= 15) break;
                this.addEditingNumber('F');
                break;
            }
            case 46: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(1, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 45: {
                this.pushReal(new Real(Settings.getMemory(1)));
                break;
            }
            case 48: {
                this.undoStack.pop();
                clearRedo = false;
                Settings.clearMemory(1);
                this.header.updateText(this.currentMode);
                break;
            }
            case 47: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(1, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 50: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(2, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 49: {
                this.pushReal(new Real(Settings.getMemory(2)));
                break;
            }
            case 52: {
                this.undoStack.pop();
                clearRedo = false;
                Settings.clearMemory(2);
                this.header.updateText(this.currentMode);
                break;
            }
            case 51: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(2, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 54: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(3, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 53: {
                this.pushReal(new Real(Settings.getMemory(3)));
                break;
            }
            case 56: {
                this.undoStack.pop();
                clearRedo = false;
                Settings.clearMemory(3);
                this.header.updateText(this.currentMode);
                break;
            }
            case 55: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(3, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 58: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(4, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 57: {
                this.pushReal(new Real(Settings.getMemory(4)));
                break;
            }
            case 60: {
                this.undoStack.pop();
                clearRedo = false;
                Settings.clearMemory(4);
                this.header.updateText(this.currentMode);
                break;
            }
            case 59: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(4, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 62: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(5, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 61: {
                this.pushReal(new Real(Settings.getMemory(5)));
                break;
            }
            case 64: {
                this.undoStack.pop();
                clearRedo = false;
                Settings.clearMemory(5);
                this.header.updateText(this.currentMode);
                break;
            }
            case 63: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(5, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 66: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.setMemory(6, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 65: {
                this.pushReal(new Real(Settings.getMemory(6)));
                break;
            }
            case 68: {
                this.undoStack.pop();
                clearRedo = false;
                Settings.clearMemory(6);
                this.header.updateText(this.currentMode);
                break;
            }
            case 67: {
                clearRedo = false;
                if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) break;
                Settings.addMemory(6, this.calcStack.peek().getValue());
                this.header.updateText(this.currentMode);
                break;
            }
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: {
                this.pushReal(new Real(Constants.constantValue(function)));
                break;
            }
            default: {
                this.addFunctionToStack(function);
            }
        }
        this.calcStack.evaluate();
        this.updateCalcTextBox(displayAsArc);
        if (this.currentMode != 1 && Settings.getAutoReturnToArithmetic() && function != 140 && function != 142 && function != 141 && function != 144 && function != 145 && function != 143 && function != 37 && function != 138 && function != 134 && function != 136 && function != 137 && function != 71) {
            this.setMode(1);
        }
        if (clearRedo && !this.isReUndoing) {
            this.redoStack.clear();
        }
    }

    private void addEditingNumber(char ch) {
        if (!this.calcStack.isEmpty() && this.calcStack.peek().getCalcType() == 1) {
            this.calcStack.peek().addToValueString(ch);
        } else {
            if (!this.calcStack.isEmpty() && this.calcStack.peek().getCalcType() == 2) {
                this.calcStack.pop();
            }
            this.calcStack.push(String.valueOf(ch));
        }
    }

    private void addFunctionToStack(int function) {
        int prio = this.getFunctionPrio(function);
        if (prio == 5) {
            if (this.calcStack.popTillNumber()) {
                StackElement top = this.calcStack.pop();
                this.calcStack.push(this.calculateDirectFunction(top.getValue(), function));
            }
        } else if (prio == 4) {
            if (this.calcStack.isEmpty() || !this.calcStack.peek().isValue()) {
                this.calcStack.push(3);
            }
        } else if (this.calcStack.popTillNumber()) {
            switch (function) {
                case 18: {
                    this.calcStack.push(5);
                    break;
                }
                case 15: {
                    this.calcStack.push(4);
                    break;
                }
                case 21: {
                    this.calcStack.push(6);
                    break;
                }
                case 24: {
                    this.calcStack.push(7);
                    break;
                }
                case 16: {
                    this.calcStack.push(8);
                }
            }
        } else if (function == 18 && this.calcStack.isEmpty()) {
            this.calcStack.push("-");
        }
    }

    private int getFunctionPrio(int function) {
        switch (function) {
            case 15: 
            case 18: {
                return 1;
            }
            case 21: 
            case 24: {
                return 2;
            }
            case 16: {
                return 3;
            }
            case 19: {
                return 4;
            }
            case 13: 
            case 14: 
            case 17: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                return 5;
            }
        }
        return 0;
    }

    private Real calculateDirectFunction(Real value, int function) {
        switch (function) {
            case 43: {
                value.exp10();
                return value;
            }
            case 28: {
                value.acos();
                return this.fromRadians(value);
            }
            case 34: {
                value.acosh();
                return value;
            }
            case 26: {
                value.asin();
                return this.fromRadians(value);
            }
            case 32: {
                value.asinh();
                return value;
            }
            case 30: {
                value.atan();
                return this.fromRadians(value);
            }
            case 36: {
                value.atanh();
                return value;
            }
            case 27: {
                this.toRadians(value).cos();
                return value;
            }
            case 33: {
                value.cosh();
                return value;
            }
            case 40: {
                value.exp();
                return value;
            }
            case 39: {
                value.fact();
                return value;
            }
            case 17: {
                value.recip();
                return value;
            }
            case 41: {
                value.ln();
                return value;
            }
            case 44: {
                value.log10();
                return value;
            }
            case 25: {
                this.toRadians(value).sin();
                return value;
            }
            case 31: {
                value.sinh();
                return value;
            }
            case 14: {
                value.sqr();
                return value;
            }
            case 13: {
                value.sqrt();
                return value;
            }
            case 29: {
                this.toRadians(value).tan();
                return value;
            }
            case 35: {
                value.tanh();
                return value;
            }
        }
        return value;
    }

    private Real toRadians(Real val) {
        if (Settings.getDRG() == 1) {
            val.mul(Real.PI);
            val.div(180);
        } else if (Settings.getDRG() == 3) {
            val.mul(Real.PI);
            val.div(200);
        }
        return val;
    }

    private Real fromRadians(Real val) {
        if (Settings.getDRG() == 1) {
            val.mul(180);
            val.div(Real.PI);
        } else if (Settings.getDRG() == 3) {
            val.mul(200);
            val.div(Real.PI);
        }
        return val;
    }

    public void equals() {
        this.handleFunction(12);
        this.repaint();
    }

    private void updateCalcTextBox() {
        this.updateCalcTextBox(false);
    }

    private void updateCalcTextBox(boolean displayAsArc) {
        if (Settings.getDoDisplayStack()) {
            this.calcTextBox.setContent(this.calcStack, displayAsArc);
        } else {
            this.calcTextBox.setContent(this.calcStack.peek(), displayAsArc);
        }
    }

    public void keyPressed(int keyCode) {
        this.buttonPressed(this.keyCode2Button(keyCode, false), true);
    }

    public void keyReleased(int keyCode) {
        this.buttonReleased(this.keyCode2Button(keyCode, false));
    }

    public void keyRepeated(int keyCode) {
        this.buttonRepeated(this.keyCode2Button(keyCode, true));
    }

    public void pointerPressed(int x, int y) {
        this.pressedX = x;
        this.pressedY = y;
        CalcButton currButton = this.position2Button(x, y);
        if (currButton == null) {
            super.pointerPressed(x, y);
        } else {
            this.buttonPressed(currButton, false);
        }
    }

    public void pointerDragged(int x, int y) {
        CalcButton currButton = this.position2Button(x, y);
        if (currButton != this.pressedButton) {
            this.buttonReleased(null);
        }
    }

    public void pointerReleased(int x, int y) {
        boolean buttonHit;
        int SAME_REGION = 7;
        int absX = Math.abs(this.pressedX - x);
        int absY = Math.abs(this.pressedY - y);
        CalcButton currButton = this.position2Button(x, y);
        boolean bl = buttonHit = this.pressedButton != null;
        if (currButton != null) {
            this.buttonReleased(currButton);
        }
        if (!buttonHit && this.pressedY < this.height - this.menuList.getHeight()) {
            if (absX < 7 && absY < 7) {
                this.handleFunction(140);
            } else if (absX > 7 && absY > 7 && 100 * absY / absX > 50 && 100 * absY / absX < 200) {
                this.handleFunction(69);
                Settings.markRepeat(display);
            } else if (absX > absY) {
                if (x > this.pressedX) {
                    this.handleFunction(this.button2Function(this.bRight, false));
                } else {
                    this.handleFunction(this.button2Function(this.bLeft, false));
                }
            } else if (y > this.pressedY) {
                this.handleFunction(this.button2Function(this.bDown, false));
            } else {
                this.handleFunction(this.button2Function(this.bUp, false));
            }
            this.repaint();
            this.serviceRepaints();
        }
    }

    private void buttonPressed(CalcButton currButton, boolean isKey) {
        this.buttonRepeat = false;
        if (currButton != null) {
            this.pressedButton = currButton;
            currButton.setIsPressed(true);
            this.repaint(currButton.getLeft(), currButton.getTop(), currButton.getWidth(), currButton.getHeight());
            this.serviceRepaints();
            if (timer != null) {
                timer.cancel();
            }
            timer = new Timer();
            timer.schedule((TimerTask)new TimerTaskRepeat(this, currButton), 600L);
        }
    }

    private void buttonRepeated(CalcButton currButton) {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        if (this.pressedButton == currButton && currButton != null && !this.buttonRepeat) {
            this.buttonRepeat = true;
            this.handleFunction(this.button2Function(currButton, true));
            currButton.repeatPressed();
            Settings.markRepeat(display);
            this.repaint();
            this.serviceRepaints();
        }
    }

    private void buttonReleased(CalcButton currButton) {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        if (currButton != null) {
            currButton.setIsPressed(false);
            if (!this.buttonRepeat && this.pressedButton != null) {
                this.handleFunction(this.button2Function(currButton, false));
            }
        }
        if (this.pressedButton != null) {
            this.pressedButton.setIsPressed(false);
            this.pressedButton = null;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.width, this.height);
        this.header.paint(g);
        this.calcTextBox.paint(g);
        if (Settings.getFullScreen()) {
            this.menuList.paint(g);
        }
        this.b1.paint(g);
        this.b2.paint(g);
        this.b3.paint(g);
        this.b4.paint(g);
        this.b5.paint(g);
        this.b6.paint(g);
        this.b7.paint(g);
        this.b8.paint(g);
        this.b9.paint(g);
        this.bStar.paint(g);
        this.b0.paint(g);
        this.bPound.paint(g);
    }

    protected void sizeChanged(int w, int h) {
        Real real = new Real();
        this.width = w > 0 ? w : this.getWidth();
        int n = this.height = h > 0 ? h : this.getHeight();
        if (this.header != null && this.calcTextBox != null && this.menuList != null) {
            this.header.updateSize(this.width, this.height);
            int localTop = this.header.getHeight();
            this.calcTextBox.updateSize(localTop, this.width);
            this.menuList.updateSize(this.width, this.height);
            int localHeight = Settings.getFullScreen() ? this.height - localTop - this.menuList.getHeight() : this.height - (localTop += this.calcTextBox.getHeight());
            this.buttonHeight = real.assign(localHeight - 7).div(4).toInteger();
            this.buttonWidth = real.assign(this.width - 4).div(3).toInteger();
            int localLeft = real.assign(this.width - this.buttonWidth * 3).div(2).toInteger();
            this.b1.setPosSize(localLeft, localTop += 2, this.buttonWidth, this.buttonHeight);
            this.b2.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.b3.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.b4.setPosSize(localLeft, localTop += this.buttonHeight + 1, this.buttonWidth, this.buttonHeight);
            this.b5.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.b6.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.b7.setPosSize(localLeft, localTop += this.buttonHeight + 1, this.buttonWidth, this.buttonHeight);
            this.b8.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.b9.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.bStar.setPosSize(localLeft, localTop += this.buttonHeight + 1, this.buttonWidth, this.buttonHeight);
            this.b0.setPosSize(localLeft + 1 + this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.bPound.setPosSize(localLeft + 2 + 2 * this.buttonWidth, localTop, this.buttonWidth, this.buttonHeight);
            this.bSoftLeft.setMenuButtonPosSize(0, this.height - this.menuList.getHeight(), this.width / 2, this.menuList.getHeight());
            this.bSoftRight.setMenuButtonPosSize(this.width / 2, this.height - this.menuList.getHeight(), this.width / 2, this.menuList.getHeight());
        }
    }

    static {
        timer = null;
    }

    static class TimerTaskRepeat
    extends TimerTask {
        private DashBoard dashBoard;
        private CalcButton currButton;

        public TimerTaskRepeat(DashBoard dashBoard, CalcButton currButton) {
            this.dashBoard = dashBoard;
            this.currButton = currButton;
        }

        public void run() {
            this.cancel();
            this.dashBoard.buttonRepeated(this.currButton);
        }
    }
}

